# Pi Network - Configurador Wi-Fi y Envio de Medidas

Aplicacion basada en Electron pensada para Raspberry Pi con pantalla tactil de pocos centimetros. La interfaz ofrece dos modos principales:

- **Caso 1 (sin conexion)**: asistir al usuario para unirse a una red Wi-Fi.
- **Caso 2 (con conexion)**: mostrar lecturas simuladas de RFID y peso, y enviarlas a la API de tipGreen.

## Requisitos

- Node.js 18 o superior.
- npm (incluido con Node.js).
- Sistema operativo con soporte para Electron (Raspberry Pi OS, Windows, Linux, etc.).

## Instalacion

```bash
npm install
```

## Uso en Raspberry Pi

```bash
npm start
```

Al iniciar:

1. **Sin Wi-Fi**: aparece el listado de redes en formato tactil. Pulsa una red, introduce la contrasena con el teclado en pantalla (si aplica) y la app pasara automaticamente al modo de lecturas cuando la conexion quede activa.
2. **Con Wi-Fi**: se muestran los datos simulados
   ```json
   {
   	"rfid": "0x0171EA400011003D",
   	"totalWeight": 42
   }
   ```
   Toca el boton grande **Enviar lecturas** para lanzar un `POST` a:
   ```
   https://tipwaste-app.deploy.ecoquimic.com/containermeasurement/rfid
   ```
   En pantalla se indica si la respuesta es `201 Created` u otro codigo HTTP.

El boton **Configurar Wi-Fi** del encabezado vuelve en cualquier momento al flujo de redes.

## Scripts npm

| Comando                 | Descripcion                                                                                                                    |
| ----------------------- | ------------------------------------------------------------------------------------------------------------------------------ |
| `npm start`             | Lanza la app en modo kiosco con comprobacion de actualizaciones.                                                               |
| `npm run build:release` | Genera el paquete de actualizacion (`.release/`, `version.json`, ZIP...).                                                      |
| `npm run deploy`        | Incrementa version y publica la aplicacion en CapRover. Ajusta `CAPROVER_*` o `PI_NETWORK_VERSION_BUMP` segun tus necesidades. |

## Despliegue en CapRover

1. (Opcional) Define credenciales en el entorno:
   ```bash
   export CAPROVER_PASSWORD="tuPassword"
   export CAPROVER_HOST="https://captain.deploy.ecoquimic.com"
   export CAPROVER_APP="pinetwork"
   ```
2. Ejecuta:
   ```bash
   npm run deploy
   ```
3. El script incrementa la version (patch por defecto), genera los artefactos y sube el tar resultante usando `npx caprover deploy`.

Tras desplegar, cada cliente actualiza automaticamente en el siguiente `npm start`, gracias al proceso en `scripts/runWithUpdate.js`.

## Datos simulados actuales

- `rfid`: `0x0171EA400011003D`
- `totalWeight`: `42`

Cuando el lector RFID y la bascula esten disponibles, sustituye la logica de simulacion en `public/renderer.js` por la integracion real.
