const { contextBridge, ipcRenderer } = require('electron');
const packageJson = require('../package.json');

contextBridge.exposeInMainWorld('wifiApi', {
  getStatus: () => ipcRenderer.invoke('wifi:get-status'),
  scan: () => ipcRenderer.invoke('wifi:scan'),
  connect: ({ ssid, password }) => ipcRenderer.invoke('wifi:connect', { ssid, password })
});

contextBridge.exposeInMainWorld('rfidApi', {
  getStatus: () => ipcRenderer.invoke('rfid:get-status'),
  onUpdate: (callback) => {
    if (typeof callback !== 'function') {
      return () => {};
    }
    const channel = 'rfid:update';
    const handler = (_event, payload) => {
      callback(payload);
    };
    ipcRenderer.on(channel, handler);
    return () => {
      ipcRenderer.removeListener(channel, handler);
    };
  }
});

contextBridge.exposeInMainWorld('appApi', {
  getVersion: () => packageJson.version
});
