# Manual de servicio técnico — Básculas

**Montaje y calibración**

Este manual está dirigido al servicio técnico para el montaje y la calibración de las básculas conectadas al sistema (indicador tipo FORCE-RS4 o compatible, comunicación Modbus RTU).

---

## 1. Montaje

### 1.1 Conexión de la celda de carga

Las básculas utilizan una **celda de carga de 6 hilos** en configuración puente de Wheatstone. La conexión al indicador debe hacerse según la siguiente correspondencia **función – color – pin**.

| Función        | Color  | Pin |
|----------------|--------|-----|
| **Excitation (+)** | Rojo   | 1   |
| **Excitation (-)** | Negro  | 2   |
| **Signal (+)**    | Verde  | 3   |
| **Signal (-)**    | Blanco | 4   |
| **Sense (+)**     | Azul   | 5   |
| **Sense (-)**     | Amarillo | 6 |

- **Excitation (+)** y **Excitation (-)**: alimentación del puente (tensión de excitación).
- **Signal (+)** y **Signal (-)**: señal de peso (salida del puente).
- **Sense (+)** y **Sense (-)**: líneas de compensación por longitud de cable; mejoran la precisión en cables largos.

**Diagrama de referencia:**

![Conexión celda de carga - 6 hilos](cables.jpeg)


**Recomendaciones de montaje:**

1. Asegurar que la celda esté fijada correctamente y sin cargas laterales.
2. No someter la celda a sobrecarga por encima del peso máximo nominal.
3. Comprobar que todos los tornillos de conexión del conector estén bien apretados.
4. Evitar cruzar los cables de señal con fuentes de interferencia (motores, variadores, etc.).

### 1.2 Conexión del indicador (Modbus RTU)

- Conectar el **puerto serie** del indicador al equipo donde corre la aplicación (USB–RS232/RS485 según el modelo).
- Parámetros típicos: **19200 baud**, 8 datos, 1 stop, sin paridad.
- **Slave ID** por defecto: **1** (comprobar en el menú del indicador si se ha cambiado).

### 1.3 Registro del puerto USB correcto (por ID)

En la aplicación se deben **registrar los puertos USB correctos** para el lector **RFID** y para la **báscula**. 

Los puertos se identifican **por ID** (no por nombre tipo ttyUSB0). La aplicación usa rutas del tipo `/dev/serial/by-id/...` para listar y guardar los puertos.

**Cómo saber qué ID es cada puerto:**

Hay que **comprobarlo probando**:

1. En la aplicación, listar los puertos disponibles (por ID).
2. **Asignar un puerto como RFID** y comprobar: acercar una etiqueta RFID y ver si la aplicación detecta el RFID. Si no detecta lecturas, ese puerto no es el del lector RFID sino el de peso.
3. **Asignar ese mismo puerto como báscula** y comprobar: ver si la aplicación **muestra pesaje**.
4. **Guardar la configuración** con los dos puertos ya identificados.

---

## 2. Calibración (por peso patrón)

No hay que hacer nada más que introducir el **peso patrón** (en kg) en el campo correspondiente y pulsar **"Setup automático"**. La aplicación guía todo el proceso.

**Cómo proceder:**

1. Introducir el **peso patrón** en el campo indicado (en kg).
2. Pulsar **"Setup automático"**.
3. Seguir los **pasos que muestra la propia aplicación** en pantalla. La aplicación irá indicando en cada momento qué hacer (por ejemplo: quitar la carga, hacer tara en vacío, colocar el peso patrón, etc.). Solo hay que ejecutar cada acción cuando lo pida y continuar con el siguiente paso hasta finalizar la calibración.


## 3. Resumen rápido

| Acción              | Cuándo usarla                         |
|---------------------|----------------------------------------|
| **Montaje**         | Seguir tabla de colores y pins; ver `cables.jpeg`. |
| **Calibración (por peso patrón)** | Introducir el peso en el campo, pulsar Setup automático y seguir los pasos que indica la aplicación. |

---

## 4. Log de setup

La aplicación escribe un **log de setup** con las operaciones de calibración y configuración. Desde la aplicación se puede abrir la ruta de ese archivo o el propio archivo para depuración y seguimiento por parte del servicio técnico.

---

*Manual de servicio técnico — Básculas. Montaje y calibración. Referencia: cableado según `cables.jpeg`.*
